const express = require("express");
const http = require("http");
const cors = require("cors");
const path = require("path");

const app = express();
const server = http.createServer(app);
const PORT = 4050 || process.env.PORT;

app.use(cors());
app.use(express.json());

const connectDB = require("./db/config");

app.get("/", (req, res) => {
    res.send("W.I.G Out Backend is Working..!!! ")
});

app.use("/api", require("./routes/user"));

app.use("/",
    express.static( path.resolve(__dirname, "./public/user/"))
);

const start = async () => {
    try {
        server.listen(PORT, ()=> {
            connectDB();
            console.log(`Server is Running on PORT: ${PORT}`);
        });
    } catch (error) {
        console.log("Having Errors While Running Server :", error)
    }
};

start();